#ifndef FONT5X7_H
#define FONT5X7_H

#ifdef __AVR__
 #include <avr/io.h>
 #include <avr/pgmspace.h>
#elif defined(ESP8266)
 #include <pgmspace.h>
#else
 #define PROGMEM
#endif

// Standard ASCII 5x7 font
// Execution of special characters PL, SK, DE, RO, S = A. Jaroszuk

static const unsigned char font[] PROGMEM = {
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x20, 0x00, 0x10, 0x10, // \001 rssi 00__
    0x08, 0x08, 0x00, 0x04, 0x04, // \002 rssi __00
    0x60, 0x60, 0x00, 0x10, 0x10, // \003 rssi 10__
    0x60, 0x60, 0x00, 0x70, 0x70, // \004 rssi 11__
    0x78, 0x78, 0x00, 0x04, 0x04, // \005 rssi __10
    0x78, 0x78, 0x00, 0x7C, 0x7C, // \006 rssi __11
    0x00, 0x1C, 0x1C, 0x1C, 0x00, // \007 weather div
    0x7A, 0x00, 0x7E, 0x12, 0x1E, // \010 ip
    0x06, 0x09, 0x09, 0x06, 0x00, // \011 degree
    0xFF, 0xE7, 0xDB, 0xE7, 0xFF, // 0x0a LINE FEED --- LF10
    0x30, 0x48, 0x3A, 0x06, 0x0E,
    0x26, 0x29, 0x79, 0x29, 0x26,
    0x40, 0x7F, 0x05, 0x05, 0x07, // 0x0d CARRIAGE RETURN ---  CR13
    0x60, 0x7F, 0x05, 0x35, 0x3F, // \016 note
    0x5A, 0x3C, 0xE7, 0x3C, 0x5A,
    0x00, 0x7F, 0x3E, 0x1C, 0x08, // \020 next/play
    0x08, 0x1C, 0x3E, 0x7F, 0x00, // \021 prev
    0x14, 0x22, 0x7F, 0x22, 0x14,
    0x00, 0x00, 0x18, 0x3C, 0x7E, // \023 speaker
    0x18, 0x00, 0x00, 0x00, 0x00, // \024 25%
    0x18, 0x42, 0x3C, 0x00, 0x00, // \025 50%
    0x18, 0x42, 0x3C, 0x42, 0x3C, // \026 100%
    0x94, 0xA2, 0xFF, 0xA2, 0x94,
    0x08, 0x04, 0x7E, 0x04, 0x08,
    0x10, 0x20, 0x7E, 0x20, 0x10,
    0x08, 0x08, 0x2A, 0x1C, 0x08,
    0x08, 0x1C, 0x2A, 0x08, 0x08,
    0x7F, 0x7F, 0x00, 0x7F, 0x7F, // \034 pause
    0x55, 0x00, 0x55, 0x55, 0x55, // \035 list
    0x30, 0x38, 0x3E, 0x38, 0x30,    // 0x1e RECORD SEPARATOR
    0x06, 0x0E, 0x3E, 0x0E, 0x06,    // 0x1f  UNIT SEPARATOR
    0x00, 0x00, 0x00, 0x00, 0x00, // 0x20 SPACE
    0x00, 0x00, 0x5F, 0x00, 0x00, // 0x21 !
    0x00, 0x07, 0x00, 0x07, 0x00, // 0x22 "
    0x14, 0x7F, 0x14, 0x7F, 0x14, // 0x23 #
    0x24, 0x2A, 0x7F, 0x2A, 0x12,       // 0x24 $
    0x23, 0x13, 0x08, 0x64, 0x62, // 0x25 %
    0x36, 0x49, 0x56, 0x20, 0x50, // 0x26 &
    0x00, 0x08, 0x07, 0x03, 0x00, // 0x27 '
    0x00, 0x1C, 0x22, 0x41, 0x00, // 0x28 (
    0x00, 0x41, 0x22, 0x1C, 0x00, // 0x29 )
    0x2A, 0x1C, 0x7F, 0x1C, 0x2A, // 0x2a *
    0x08, 0x08, 0x3E, 0x08, 0x08, // 0x2b +
    0x00, 0x80, 0x70, 0x30, 0x00, // 0x2c ,
    0x08, 0x08, 0x08, 0x08, 0x08, // 0x2d -
    0x00, 0x00, 0x60, 0x60, 0x00, // 0x2e .
    0x20, 0x10, 0x08, 0x04, 0x02, // 0x2f /
    0x3E, 0x51, 0x49, 0x45, 0x3E, // 0x30 0
    0x00, 0x42, 0x7F, 0x40, 0x00, // 0x31 1
    0x72, 0x49, 0x49, 0x49, 0x46, // 0x32 2
    0x21, 0x41, 0x49, 0x4D, 0x33, // 0x33 3
    0x18, 0x14, 0x12, 0x7F, 0x10, // 0x34 4
    0x27, 0x45, 0x45, 0x45, 0x39, // 0x35 5
    0x3C, 0x4A, 0x49, 0x49, 0x31, // 0x36 6
    0x41, 0x21, 0x11, 0x09, 0x07, // 0x37 7
    0x36, 0x49, 0x49, 0x49, 0x36, // 0x38 8
    0x46, 0x49, 0x49, 0x29, 0x1E, // 0x39 9
    0x00, 0x00, 0x14, 0x00, 0x00, // 0x3a :
    0x00, 0x40, 0x34, 0x00, 0x00, // 0x3b ;
    0x00, 0x08, 0x14, 0x22, 0x41, // 0x3C <
    0x14, 0x14, 0x14, 0x14, 0x14, // 0x3D =
    0x00, 0x41, 0x22, 0x14, 0x08, // 0x3E >
    0x02, 0x01, 0x59, 0x09, 0x06, // 0x3f ?
    0x3E, 0x41, 0x5D, 0x59, 0x4E, // 0x40 @
    0x7C, 0x12, 0x11, 0x12, 0x7C, // 0x41 A
    0x7F, 0x49, 0x49, 0x49, 0x36, // 0x42 B
    0x3E, 0x41, 0x41, 0x41, 0x22, // 0x43 C
    0x7F, 0x41, 0x41, 0x41, 0x3E, // 0x44 D
    0x7F, 0x49, 0x49, 0x49, 0x41, // 0x45 E
    0x7F, 0x09, 0x09, 0x09, 0x01, // 0x46 F
    0x3E, 0x41, 0x41, 0x51, 0x73, // 0x47 G
    0x7F, 0x08, 0x08, 0x08, 0x7F, // 0x48 H
    0x00, 0x41, 0x7F, 0x41, 0x00, // 0x49 I
    0x20, 0x40, 0x41, 0x3F, 0x01, // 0x4a J
    0x7F, 0x08, 0x14, 0x22, 0x41, // 0x4b K
    0x7F, 0x40, 0x40, 0x40, 0x40, // 0x4c L
    0x7F, 0x02, 0x1C, 0x02, 0x7F, // 0x4d M
    0x7F, 0x04, 0x08, 0x10, 0x7F, // 0x4e N
    0x3E, 0x41, 0x41, 0x41, 0x3E, // 0x4f O
    0x7F, 0x09, 0x09, 0x09, 0x06, // 0x50 P
    0x3E, 0x41, 0x51, 0x21, 0x5E, // 0x51 Q
    0x7F, 0x09, 0x19, 0x29, 0x46, // 0x52 R
    0x26, 0x49, 0x49, 0x49, 0x32, // 0x53 S
    0x03, 0x01, 0x7F, 0x01, 0x03, // 0x54 T
    0x3F, 0x40, 0x40, 0x40, 0x3F, // 0x55 U
    0x1F, 0x20, 0x40, 0x20, 0x1F, // 0x56 V
    0x3F, 0x40, 0x38, 0x40, 0x3F, // 0x57 W
    0x63, 0x14, 0x08, 0x14, 0x63, // 0x58 X
    0x03, 0x04, 0x78, 0x04, 0x03, // 0x59 Y
    0x61, 0x59, 0x49, 0x4D, 0x43, // 0x5a Z
    0x00, 0x7F, 0x41, 0x41, 0x41, // 0x5b [
    0x02, 0x04, 0x08, 0x10, 0x20, // 0x5c BACKSLASH
    0x00, 0x41, 0x41, 0x41, 0x7F, // 0x5d [
    0x04, 0x02, 0x01, 0x02, 0x04, // 0x5e ^
    0x40, 0x40, 0x40, 0x40, 0x40, // 0x5f _
    0x00, 0x03, 0x07, 0x08, 0x00, // 0x60 `
    0x20, 0x54, 0x54, 0x78, 0x40, // 0x61 a
    0x7F, 0x28, 0x44, 0x44, 0x38, // 0x62 b
    0x38, 0x44, 0x44, 0x44, 0x28, // 0x63 c
    0x38, 0x44, 0x44, 0x28, 0x7F, // 0x64 d
    0x38, 0x54, 0x54, 0x54, 0x18, // 0x65 e
    0x00, 0x08, 0x7E, 0x09, 0x02, // 0x66 f
    0x18, 0xA4, 0xA4, 0x9C, 0x78, // 0x67 g
    0x7F, 0x08, 0x04, 0x04, 0x78, // 0x68 h
    0x00, 0x44, 0x7D, 0x40, 0x00, // 0x69 i
    0x20, 0x40, 0x40, 0x3D, 0x00, // 0x6a j
    0x7F, 0x10, 0x28, 0x44, 0x00, // 0x6b k
    0x00, 0x41, 0x7F, 0x40, 0x00, // 0x6c l
    0x7C, 0x04, 0x78, 0x04, 0x78, // 0x6d m
    0x7C, 0x08, 0x04, 0x04, 0x78, // 0x6e n
    0x38, 0x44, 0x44, 0x44, 0x38, // 0x6f o
    0xFC, 0x18, 0x24, 0x24, 0x18, // 0x70 p
    0x18, 0x24, 0x24, 0x18, 0xFC, // 0x71 q
    0x7C, 0x08, 0x04, 0x04, 0x08, // 0x72 r
    0x48, 0x54, 0x54, 0x54, 0x24, // 0x73 s
    0x04, 0x04, 0x3F, 0x44, 0x24, // 0x74 t
    0x3C, 0x40, 0x40, 0x20, 0x7C, // 0x75 u
    0x1C, 0x20, 0x40, 0x20, 0x1C, // 0x76 v
    0x3C, 0x40, 0x30, 0x40, 0x3C, // 0x77 w
    0x44, 0x28, 0x10, 0x28, 0x44, // 0x78 x
    0x4C, 0x90, 0x90, 0x90, 0x7C, // 0x79 y
    0x44, 0x64, 0x54, 0x4C, 0x44, // 0x7a z
    0x00, 0x08, 0x36, 0x41, 0x00, // 0x7b {
    0x00, 0x00, 0x77, 0x00, 0x00, // 0x7c |
    0x00, 0x41, 0x36, 0x08, 0x00, // 0x7d }
    0x02, 0x01, 0x02, 0x04, 0x02, // 0x7e ~
    0x3C, 0x26, 0x23, 0x26, 0x3C, // ⌂  \0x7f
    0x1E, 0xA1, 0xA1, 0x61, 0x12, // Ç  \0x80
    0x3A, 0x40, 0x40, 0x20, 0x7A, // u-umlaut  ü  \0x81
    0x38, 0x54, 0x56, 0x55, 0x08, // é SK   \0x82
    0x21, 0x55, 0x55, 0x79, 0x41, // â  RO  \0x83
    0x22, 0x54, 0x54, 0x78, 0x42, // a-umlaut \  ä  \0x84
    0x21, 0x55, 0x54, 0x78, 0x40, // à  \0x85
    0x02, 0x24, 0x54, 0x78, 0x40, // å  SE \0x86
    0x0C, 0x1E, 0x52, 0x72, 0x12, // ç  \0x87
    0x39, 0x55, 0x55, 0x55, 0x59, // ê  \0x88
    0x39, 0x54, 0x54, 0x54, 0x59, // ë  \0x89
    0x39, 0x55, 0x54, 0x54, 0x58, // è  \0x8a
    0x00, 0x00, 0x45, 0x7C, 0x41, // ï  \0x8b
    0x24, 0x56, 0x55, 0x7E, 0x40, // î  RO \0x8c
    0x00, 0x01, 0x45, 0x7C, 0x40, // ì  \0x8d
    0x7D, 0x12, 0x11, 0x12, 0x7D, // A-umlaut \ Ä  \0x8e
    0x7E, 0x11, 0x0A, 0x11, 0x7E, // Å  SE  \0x8f
    0x7C, 0x54, 0x56, 0x55, 0x44, // É  SK   \0x90
    0x20, 0x54, 0x54, 0x7C, 0x54, // æ  \0x91
    0x7C, 0x0A, 0x09, 0x7F, 0x49, // Æ  \0x92
    0x32, 0x49, 0x49, 0x49, 0x32, // ô  \0x93
    0x3A, 0x44, 0x44, 0x44, 0x3A, // o-umlaut \ ö  \0x94
    0x32, 0x4A, 0x48, 0x48, 0x30, // ò  \0x95
    0x3A, 0x41, 0x41, 0x21, 0x7A, // û  \0x96
    0x3A, 0x42, 0x40, 0x20, 0x78, // ù  \0x97
    0x00, 0x9D, 0xA0, 0xA0, 0x7D, // ÿ  \0x98
    0x3D, 0x42, 0x42, 0x42, 0x3D, // O-umlaut  \ Ö  \0x99
    0x3D, 0x40, 0x40, 0x40, 0x3D, // U-umlauf  \ Ü  \0x9a
    0x3C, 0x24, 0xFF, 0x24, 0x24, // ¢  \0x9b
    0x48, 0x7E, 0x49, 0x43, 0x66, // £  \0x9c
    0x3C, 0x40, 0x42, 0x40, 0x3C, // Ů SK  \0x9d
    0xFF, 0x09, 0x29, 0xF6, 0x20, // ₧  \0x9e
    0xC0, 0x88, 0x7E, 0x09, 0x03, // ƒ  \0x9f
    0x20, 0x54, 0x54, 0x79, 0x41, // á  \0xa0
    0x00, 0x00, 0x44, 0x7D, 0x41, // í  \0xa1
    0x30, 0x48, 0x48, 0x4A, 0x32, // ó  \0xa2
    0x38, 0x40, 0x40, 0x22, 0x7A, // ú  \0xa3
    0x00, 0x7A, 0x0A, 0x0A, 0x72, // ñ  \0xa4
    0x7D, 0x0D, 0x19, 0x31, 0x7D, // Ñ  \0xa5
    0x26, 0x29, 0x29, 0x2F, 0x28, // ª  \0xa6
    0x26, 0x29, 0x29, 0x29, 0x26, // º  \0xa7
    0x20, 0x30, 0x38, 0x3C, 0x3E, // WIFI  \0xa8
    0x38, 0x08, 0x08, 0x08, 0x08, // ⌐  \0xa9
    0x08, 0x08, 0x08, 0x08, 0x38, // ¬  \0xaa
    0x2F, 0x10, 0xC8, 0xAC, 0xBA, // ½  \0xab
    0x2F, 0x10, 0x28, 0x34, 0xFA, // ¼  \0xac
    0x00, 0x00, 0x7B, 0x00, 0x00, // ¡  \0xad
    0x08, 0x14, 0x2A, 0x14, 0x22, // «  \0xae
    0x22, 0x14, 0x2A, 0x14, 0x08, // »  \0xaf
    0x55, 0x00, 0x55, 0x00, 0x55, // 25% block
    0xAA, 0x55, 0xAA, 0x55, 0xAA, // 50% block  \0xb0
    0xFF, 0x55, 0xFF, 0x55, 0xFF, // 75% block 
    0x7C, 0x09, 0x12, 0x21, 0x7C, //   Ň SK   \0xb3
    0x78, 0x11, 0x0A, 0x09, 0x70, //   ň SK   \0xb4
    0x7C, 0x14, 0x16, 0x15, 0x68, //   Ŕ SK   \0xb5
    0x78, 0x11, 0x0A, 0x09, 0x10, //   ř SK   \0xb6
    0x3C, 0x12, 0x11, 0x12, 0x7C, //   Ą  PL  \0xb7 
    0x10, 0x2A, 0x2A, 0x6A, 0x3C, //   ą  PL  \0xb8  
    0x44, 0x64, 0x55, 0x4C, 0x44, //   ż  PL  \0xb9    
    0x61, 0x5B, 0x49, 0x4D, 0x43, //   Ż  PL  \0xba  
    0x44, 0x64, 0x56, 0x4D, 0x44, // ź   PL   \0xbb   
    0x42, 0x66, 0x53, 0x4A, 0x46, // Ź   PL   \0xbc  
    0x38, 0x44, 0x46, 0x45, 0x44, // ć   PL   \0xbd 
    0x38, 0x44, 0x46, 0x45, 0x38, // ó	 PL   \0xbe   
    0x3C, 0x42, 0x43, 0x42, 0x3C, // Ó	 PL   \0xbf   
    0x7C, 0x08, 0x06, 0x05, 0x78, // ń   PL   \0xc0       
    0x7F, 0x04, 0x0B, 0x10, 0x7F, // Ń	 PL   \0xc1   
    0x48, 0x55, 0x56, 0x55, 0x34, // Š   SK   \0xc2
    0x00, 0x51, 0x7A, 0x29, 0x00, // š   SK   \0xc3
    0x3C, 0x42, 0x43, 0x42, 0x24, // Ć   PL   \0xc4   
    0x04, 0x05, 0x7E, 0x05, 0x04, // Ť   SK   \0xc5
    0x00, 0x08, 0x3C, 0x49, 0x22, // ť   SK   \0xc6
    0x64, 0x55, 0x56, 0x55, 0x4C, // Ž   SK   \0xc7
    0x00, 0x69, 0x7A, 0x59, 0x00, // ž   SK   \0xc8
    0x38, 0x45, 0x46, 0x45, 0x44, // Č   SK   \0xc9
    0x30, 0x49, 0x4A, 0x49, 0x48, // č   SK   \0xca
    0x48, 0x54, 0x56, 0x54, 0x24, // ś   PL   \0xcb     
    0x26, 0x49, 0x4B, 0x49, 0x32, // Ś   PL   \0xcc  
    0x14, 0x14, 0x14, 0x14, 0x14, //horiz lines  ═  \0xcd
    0x7C, 0x45, 0x46, 0x45, 0x38, // Ď SK   \0xce
    0x00, 0x51, 0x7F, 0x44, 0x00, // ł PL   \0xcf   
    0x7F, 0x48, 0x44, 0x40, 0x40, // Ł PL   \0xd0
    0x20, 0x70, 0x50, 0x7D, 0x02, // ď SK   \0xd1
    0x7C, 0x40, 0x42, 0x41, 0x40, // Ĺ SK   \0xd2
    0x02, 0x45, 0x7C, 0x40, 0x00, // ĺ SK   \0xd3
    0x7C, 0x41, 0x42, 0x40, 0x40, // Ľ SK   \0xd4
    0x00, 0x44, 0x7C, 0x41, 0x02, // ľ SK   \0xd5
    0x1C, 0x2A, 0x2A, 0x6A, 0x0C, // ę PL   \0xd6   
    0x7F, 0x49, 0x49, 0xC9, 0x41, // Ę PL   \0xd7
    0x78, 0x14, 0x16, 0x15, 0x78, // Á SK   \0xd8
    0x20, 0x54, 0x56, 0x79, 0x40, // á SK   \0xd9
    0x00, 0x44, 0x7E, 0x45, 0x00, // Í SK   \0xda
    0x00, 0x40, 0x7A, 0x41, 0x00, // í SK   \0xdb
    0x38, 0x46, 0x45, 0x46, 0x38, // Ô SK   \0xdc
    0x30, 0x4A, 0x49, 0x4A, 0x30, // ô SK   \0xdd
    0x3C, 0x40, 0x42, 0x41, 0x3C, // Ú SK   \0xde
    0x38, 0x40, 0x42, 0x21, 0x78, // ú SK   \0xdf
    0x38, 0x44, 0x44, 0x38, 0x44, // α  \0xe0
    0xFC, 0x4A, 0x4A, 0x4A, 0x34, // sharp-s or beta \0xe1
    0x04, 0x08, 0x72, 0x09, 0x04, // Ý SK   \0xe2
    0x18, 0xA0, 0xA2, 0xA1, 0x78, // ý SK   \0xe3
    0x63, 0x55, 0x49, 0x41, 0x63, // Σ  \0xe4
    0x38, 0x44, 0x44, 0x3C, 0x04, // σ  \0xe5
    0x40, 0x7E, 0x20, 0x1E, 0x20, // µ  \0xe6
    0x06, 0x02, 0x7E, 0x02, 0x02, // τ  \0xe7
    0x38, 0x40, 0x42, 0x20, 0x78, // ů SK   \0xe8
    0x1C, 0x2A, 0x49, 0x2A, 0x1C, // Θ  \0xe9
    0x4C, 0x72, 0x01, 0x72, 0x4C, // Ω  \0xea
    0x30, 0x4A, 0x4D, 0x4D, 0x30, // δ  \0xeb
    0x30, 0x48, 0x78, 0x48, 0x30, // ∞  \0xec
    0xBC, 0x62, 0x5A, 0x46, 0x3D, // φ  \0xed
    0x78, 0x16, 0x15, 0x16, 0x78, // Â  RO \0xee
    0x24, 0x2A, 0x6A, 0x2A, 0x32, // ș  RO \0xef
    0x26, 0x29, 0x69, 0x29, 0x12, // Ș  RO \0xf0
    0x04, 0x04, 0x3F, 0x44, 0x64, // ț  RO \0xf1
    0x03, 0x01, 0x7F, 0x01, 0x43, // Ț  RO \0xf2
    0x00, 0x02, 0x7D, 0x02, 0x00, // Î  RO \0xf3
    0x24, 0x55, 0x56, 0x7D, 0x40, // ă  RO \0xf4
    0x78, 0x15, 0x16, 0x15, 0x78, // Ă  RO \0xf5
    0x08, 0x08, 0x6B, 0x6B, 0x08, // ÷  \0xf6
    0x36, 0x12, 0x36, 0x24, 0x36, // ≈  \0xf7
    0x06, 0x0F, 0x09, 0x0F, 0x06, // °  \0xf8
    0x00, 0x00, 0x18, 0x18, 0x00, // ∙  \0xf9
    0x00, 0x00, 0x10, 0x10, 0x00, // ·  \0xfa
    0x30, 0x40, 0xFF, 0x01, 0x01, // √  \0xfb
    0x00, 0x1F, 0x01, 0x01, 0x1E, // ⁿ  \0xfc
    0x00, 0x19, 0x1D, 0x17, 0x12, // ²  \0xfd
    0x00, 0x3C, 0x3C, 0x3C, 0x3C, // ■  \0xfe
    0x00, 0x00, 0x00, 0x00, 0x00 // #255 NBSP \0xff
};

static inline void avoid_unused_const_variable_compiler_warning(void) {
  (void)font;
}
#endif // FONT5X7_H
