#include "namedays.h"

#ifdef NAMEDAYS_FILE     // "namedays"
#if NAMEDAYS_FILE == HU
  #include "../../locale/namedays_HU.h"
#elif NAMEDAYS_FILE == PL
  #include "../../locale/namedays_PL.h"
//#elif NAMEDAYS_FILE == RU
//  #include "../../locale/namedays_RU.h"
#elif NAMEDAYS_FILE == EL
  #include "../../locale/namedays_EL.h"
#elif NAMEDAYS_FILE == NL
  #include "../../locale/namedays_NL.h"  
#else
  #error "Unsupported NAMEDAYS_FILE"
#endif

// --- Zmienne rotacji ---
uint32_t namedayLastRotation = 0;  // ostatni czas rotacji
uint8_t  namedayCurrentIndex = 0;  // bieżący indeks imienia
char     currentNamedayBuffer[30]; // bufor dla bieżącego imienia
int      lastNamedayDay = -1;      // ostatni dzień do resetowania rotacji
int      lastNamedayMonth = -1;    // ostatni miesiąc do resetowania rotacji

// Funkcja, która zwraca bieżące imię dla danego dnia roku, zmieniając co 4 sekundy
const char *getNameDay(int month, int day) {
  const int daysInMonth[] = {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
  int       dayOfYear = day - 1; // a hónap napja (0-alapú)

  for (int i = 0; i < month - 1; i++) {
    dayOfYear += daysInMonth[i];
  }

  if (dayOfYear < 0 || dayOfYear >= 366) {
    return ""; // üres karakterláncot ad vissza, ha a nap érvénytelen
  }

  // Sprawdź, czy zmienił się dzień - jeśli tak, zresetuj rotację
  if (lastNamedayDay != day || lastNamedayMonth != month) {
    lastNamedayDay = day;
    lastNamedayMonth = month;
    namedayCurrentIndex = 0;
    namedayLastRotation = millis();
    memset(currentNamedayBuffer, 0, sizeof(currentNamedayBuffer)); // przy zmianie dnia czyści bufor
  }

  // Pobranie ciągu znaków zawierającego imiona dnia
  char tempBuffer[80];
  //strcpy_P(tempBuffer, (const char *)pgm_read_ptr(&namedays[dayOfYear]));
  strcpy(tempBuffer, namedays[dayOfYear]);

  //  Serial.printf("displayILI9488.cpp -> Odczytane imieniny: %s%\n", tempBuffer);
  // Zliczamy liczbę imion w ciągu (oddzielonych przecinkami)
  uint8_t nameCount = 1;
  for (int i = 0; tempBuffer[i] != '\0'; i++) {
    if (tempBuffer[i] == ',')
      nameCount++;
  }

  // Jeśli jest tylko jedno imię, nie zmieniaj
  if (nameCount == 1) {
    memset(currentNamedayBuffer, 0, sizeof(currentNamedayBuffer)); // wyczyść bufor
    strlcpy(currentNamedayBuffer, tempBuffer, sizeof(currentNamedayBuffer));
    return currentNamedayBuffer;
  }

  // Sprawdza, czy upłynęły 2 sekundy od ostatniej rotacji
  uint32_t currentTime = millis();
  if (currentTime - namedayLastRotation >= 2000) { // 2 sekundy
    namedayLastRotation = currentTime;
    namedayCurrentIndex++;

    // Resetowanie indeksu, jeśli przekracza liczbę imion
    if (namedayCurrentIndex >= nameCount) {
      namedayCurrentIndex = 0;
    }
  }

  // Znajdź odpowiednie imię z listy
  //strcpy_P(tempBuffer, (const char *)pgm_read_ptr(&namedays[dayOfYear])); // Kopiuje ponownie, ponieważ strtok niszczy
 strcpy(tempBuffer, namedays[dayOfYear]);

  char *token = strtok(tempBuffer, ",");
  for (uint8_t i = 0; i < namedayCurrentIndex && token != NULL; i++) {
    token = strtok(NULL, ",");
  }

  if (token) {
    // Usuwamy spacje z początku
    while (*token == ' ' || *token == '\t')
      token++;

    memset(currentNamedayBuffer, 0, sizeof(currentNamedayBuffer)); // czyszczenie bufora przed zapisem
    strlcpy(currentNamedayBuffer, token, sizeof(currentNamedayBuffer));
    return currentNamedayBuffer;
  }

  return "";
}

#endif // NAMEDAY_ENABLED
