#ifndef NAMEDAYS_H
#define NAMEDAYS_H

#include "options.h"

// Csak akkor fordul, ha van NAMEDAYS_FILE definiálva
#ifdef NAMEDAYS_FILE

#include <Arduino.h>

// Tömb deklaráció
extern const char* namedays[];

// Label deklaráció
extern const char* nameday_label;

// Zmienne rotacji imienin
extern uint32_t namedayLastRotation;      // ostatni czas rotacji
extern uint8_t  namedayCurrentIndex;      // bieżący indeks imienia
extern char     currentNamedayBuffer[30]; // bufor dla bieżącego imienia
extern int      lastNamedayDay;           // ostatni dzień do resetowania rotacji
extern int      lastNamedayMonth;         // ostatni miesiąc do resetowania rotacji

// Funkcja, która zwraca bieżące imię dla danego dnia roku, zmieniając co 4 sekundy
const char *getNameDay(int month, int day);

#endif // NAMEDAYS_FILE

#endif // NAMEDAYS_H
