
/*************************************************************************************
    ST7796 480X320 displays configuration file.
    Copy this file to yoRadio/src/displays/conf/displayST7789conf_custom.h
    and modify it
    More info on https://github.com/e2002/yoradio/wiki/Widgets#widgets-description
*************************************************************************************/

#ifndef displayILI9488conf_h
#define displayILI9488conf_h

#include "../widgets/widgetsconfig.h"

#define DSP_WIDTH       480
#define DSP_HEIGHT      320
#define TFT_FRAMEWDT    10
#define MAX_WIDTH       DSP_WIDTH-TFT_FRAMEWDT*2

#if BITRATE_FULL
  #define TITLE_FIX 44
#else
  #define TITLE_FIX 0
#endif
#define bootLogoTop     30


/* SROLLS  */                            /* {{ left, top, fontsize, align }, buffsize, uppercase, width, scrolldelay, scrolldelta, scrolltime } */
const ScrollConfig metaConf       PROGMEM = {{ TFT_FRAMEWDT, TFT_FRAMEWDT, 4, WA_LEFT }, 140, true, MAX_WIDTH, 5000, 4, 60 };
const ScrollConfig title1Conf     PROGMEM = {{TFT_FRAMEWDT+6, 60, 2, WA_LEFT}, 140, true, MAX_WIDTH-(TITLE_FIX==0?6*2*7-6:TITLE_FIX)-18, 5000, 4, 60}; // -18px (dodatkowe 12px od ikonki)
const ScrollConfig title2Conf     PROGMEM = {{TFT_FRAMEWDT+6, 86, 2, WA_LEFT}, 140, true, MAX_WIDTH-TITLE_FIX-18, 5000, 4, 60}; // -18px (dodatkowe 12px od ikonki)
const ScrollConfig playlistConf   PROGMEM = {{ TFT_FRAMEWDT, 146, 3, WA_LEFT }, 140, true, MAX_WIDTH, 1000, 4, 60 };
const ScrollConfig apTitleConf    PROGMEM = {{ TFT_FRAMEWDT, TFT_FRAMEWDT, 4, WA_CENTER }, 140, false, MAX_WIDTH, 0, 4, 60 };
const ScrollConfig apSettConf     PROGMEM = {{ TFT_FRAMEWDT, 320-TFT_FRAMEWDT-16, 2, WA_LEFT }, 140, false, MAX_WIDTH, 0, 5, 60 };
const ScrollConfig weatherConf    PROGMEM = {{ TFT_FRAMEWDT+6, 112, 2, WA_LEFT }, 140, true, MAX_WIDTH, 5000, 4, 60 }; 

/* BACKGROUNDS  */                       /* {{ left, top, fontsize, align }, width, height, outlined } */
const FillConfig  metaBGConf     PROGMEM = {{3, 45, 0, WA_CENTER}, DSP_WIDTH - 6, 1, true}; 
const FillConfig  metaBGConfInv  PROGMEM = {{ 0, 50, 0, WA_LEFT }, DSP_WIDTH, 2, false };
const FillConfig  volbarConf     PROGMEM = {{TFT_FRAMEWDT, DSP_HEIGHT - TFT_FRAMEWDT - 4, 0, WA_LEFT}, MAX_WIDTH, 4, true};
const FillConfig  playlBGConf    PROGMEM = {{ 0, 138, 0, WA_LEFT }, DSP_WIDTH, 36, false };
const FillConfig  heapbarConf    PROGMEM = {{ 0, DSP_HEIGHT-2, 0, WA_LEFT }, DSP_WIDTH, 2, false };

/* WIDGETS  */ /* { left, top, fontsize, align } */
const WidgetConfig bootstrConf   PROGMEM = {0, 243, 2, WA_CENTER};
const WidgetConfig bitrateConf   PROGMEM = {6, 62, 2, WA_RIGHT};
const WidgetConfig voltxtConf    PROGMEM = {0, DSP_HEIGHT - 32, 2, WA_CENTER}; // 
const WidgetConfig iptxtConf     PROGMEM = {TFT_FRAMEWDT, DSP_HEIGHT - 32, 2, WA_LEFT};
const WidgetConfig channelConf   PROGMEM = {300, DSP_HEIGHT - 32, 2, WA_LEFT};
const WidgetConfig rssiConf      PROGMEM = { TFT_FRAMEWDT+3, DSP_HEIGHT-32, 2, WA_RIGHT };  // +3px w lewo (1mm)
const WidgetConfig numConf       PROGMEM = {0, 200, 70, WA_CENTER};
const WidgetConfig apNameConf    PROGMEM = {TFT_FRAMEWDT, 88, 3, WA_CENTER};
const WidgetConfig apName2Conf   PROGMEM = {TFT_FRAMEWDT, 120, 3, WA_CENTER};
const WidgetConfig apPassConf    PROGMEM = {TFT_FRAMEWDT, 173, 3, WA_CENTER};
const WidgetConfig apPass2Conf   PROGMEM = {TFT_FRAMEWDT, 205, 3, WA_CENTER};
const WidgetConfig clockConf     PROGMEM = {10, 208, 2, WA_RIGHT}; 
const WidgetConfig vuConf        PROGMEM = {35, 258, 1, WA_CENTER}; 
const WidgetConfig bootWdtConf   PROGMEM = {0, 216, 1, WA_CENTER};
const WidgetConfig namedayConf    = { TFT_FRAMEWDT, 200, 2, WA_LEFT };  
const WidgetConfig dateConf    = { TFT_FRAMEWDT *2, 229, 1, WA_LEFT };  
const WidgetConfig sunriseConf   PROGMEM = {TFT_FRAMEWDT+4, 152, 2, WA_LEFT};  
const WidgetConfig sunsetConf    PROGMEM = {TFT_FRAMEWDT+4, 174, 2, WA_LEFT};   
const ProgressConfig bootPrgConf PROGMEM = {90, 14, 4};

//{{ left, top, fontsize, align }dimension}
const BitrateConfig fullbitrateConf PROGMEM = {{DSP_WIDTH-TFT_FRAMEWDT-44, 56, 2, WA_LEFT}, 42}; // Y: 56 zamiast 59 (w górę o 3px = 0.5mm)

/* BANDS { onebandwidth (width), onebandheight (height), bandsHspace (space), bandsVspace (vspace), numofbands (perheight), fadespeed (fadespeed)} */
#ifdef BOOMBOX_STYLE
const VUBandsConfig bandsConf PROGMEM = {200, 7, 4, 2, 20, 12}; // 29
#else
const VUBandsConfig bandsConf PROGMEM = { 406, 7, 3, 2, 29, 23};
#endif

/* STRINGS  */
const char numtxtFmt[] PROGMEM = "%d";
const char rssiFmt[] PROGMEM = " %ddBm";//xa8
// const char rssiFmt[] PROGMEM = "WiFi %d"; // Original
const char channelFmt[] PROGMEM = "CH:%d";
const char iptxtFmt[] PROGMEM = "%s";
const char voltxtFmt[] PROGMEM = "\023\025%d%%"; 
const char bitrateFmt[] PROGMEM = "%d kBs";

/* MOVES  */ /* { left, top, width } */
const MoveConfig clockMove     PROGMEM = {0, 176, -1};
const MoveConfig weatherMove   PROGMEM = {TFT_FRAMEWDT+6, 112, MAX_WIDTH}; 
const MoveConfig weatherMoveVU PROGMEM = {TFT_FRAMEWDT+6, 112, MAX_WIDTH}; 

#endif