#ifndef YOFONT10X14_H
#define YOFONT10X14_H

#ifdef __AVR__
#include <avr/io.h>
#include <avr/pgmspace.h>
#elif defined(ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

// Standard ASCII 10x14 font

const unsigned char yofont10x14[] PROGMEM = {
0x0A, 0x0E, 0x00, 0xFF,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0x33, 0x33, 0x33, 0x33, 0x03, 0x33, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0xFC, 0x0F, 0xFC, 0x0F,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0xCF, 0x3C, 0xCF, 0x3C, 0xFF, 0x3C, 0xFF, 0x3C, 0xCF, 0x3C, 0xCF, 0x3C, 0xFC, 0x0F, 0xFC, 0x0F,
0x0A, 0xF0, 0x00, 0xF0, 0x00, 0xFC, 0x03, 0xFC, 0x03, 0xF0, 0x0F, 0xF0, 0x0F, 0xFC, 0x03, 0xFC, 0x03, 0xF0, 0x00, 0xF0, 0x00,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0xFC, 0x0F, 0xFC, 0x0F, 0xF0, 0x03, 0xF0, 0x03, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0xF0, 0x03, 0xF0, 0x03, 0xCC, 0x30, 0xCC, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0xCC, 0x30, 0xCC, 0x30, 0xF0, 0x03, 0xF0, 0x03,
0x0A, 0xC0, 0x03, 0xC0, 0x03, 0xF0, 0x33, 0xF0, 0x33, 0xFF, 0x3F, 0xFF, 0x3F, 0xF0, 0x33, 0xF0, 0x33, 0xC0, 0x03, 0xC0, 0x03,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0xF0, 0x03, 0xF0, 0x03, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x0F, 0x3C, 0x0F, 0x3C, 0x0F, 0x3C, 0x0F, 0x3C, 0x0F, 0x3C, 0x0F, 0x3C, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0x30, 0x03, 0x30, 0x03, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x0F, 0x3C, 0x0F, 0x3C, 0xCF, 0x3C, 0xCF, 0x3C, 0x0F, 0x3C, 0x0F, 0x3C, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0x00, 0x0F, 0x00, 0x0F, 0xC0, 0x30, 0xC0, 0x30, 0xF3, 0x30, 0xF3, 0x30, 0x0F, 0x0F, 0x0F, 0x0F, 0x3F, 0x00, 0x3F, 0x00,
0x0A, 0x3C, 0x00, 0x3C, 0x00, 0xC3, 0x0C, 0xC3, 0x0C, 0xC3, 0x3F, 0xC3, 0x3F, 0xC3, 0x0C, 0xC3, 0x0C, 0x3C, 0x00, 0x3C, 0x00,
0x0A, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x33, 0x00, 0x33, 0xFF, 0x0F, 0xFF, 0x0F, 0x0C, 0x00, 0x0C, 0x00, 0xF0, 0x00, 0xF0, 0x00,
0x0A, 0x00, 0x3C, 0x00, 0x3C, 0xFF, 0x3F, 0xFF, 0x3F, 0x33, 0x00, 0x33, 0x00, 0x33, 0x0F, 0x33, 0x0F, 0xFF, 0x0F, 0xFF, 0x0F,
0x0A, 0xCC, 0x0C, 0xCC, 0x0C, 0xF0, 0x03, 0xF0, 0x03, 0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0x03, 0xF0, 0x03, 0xCC, 0x0C, 0xCC, 0x0C,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xFC, 0x0F, 0xFC, 0x0F, 0xF0, 0x03, 0xF0, 0x03, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0xFC, 0x0F, 0xFC, 0x0F, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x30, 0x03, 0x30, 0x03, 0x0C, 0x0C, 0x0C, 0x0C, 0xFF, 0x3F, 0xFF, 0x3F, 0x0C, 0x0C, 0x0C, 0x0C, 0x30, 0x03, 0x30, 0x03,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x33, 0xFF, 0x33, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x33, 0xFF, 0x33, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x3C, 0x00, 0x3C, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x00, 0x03, 0x00, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xCC, 0x30, 0xCC, 0x30, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xC3, 0x0C, 0xC3, 0x0C,
0x0A, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C,
0x0A, 0x30, 0x33, 0x30, 0x33, 0x0C, 0x3C, 0x0C, 0x3C, 0xFF, 0x3F, 0xFF, 0x3F, 0x0C, 0x3C, 0x0C, 0x3C, 0x30, 0x33, 0x30, 0x33,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x00, 0x30, 0x00, 0xFC, 0x3F, 0xFC, 0x3F, 0x30, 0x00, 0x30, 0x00, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x00, 0x03, 0xFF, 0x0F, 0xFF, 0x0F, 0x00, 0x03, 0x00, 0x03, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xCC, 0x0C, 0xCC, 0x0C, 0xF0, 0x03, 0xF0, 0x03, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0xCC, 0x0C, 0xCC, 0x0C, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03,
0x0A, 0xF0, 0x03, 0xF0, 0x03, 0xFC, 0x0F, 0xFC, 0x0F, 0xC0, 0x00, 0xC0, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0xF0, 0x03, 0xF0, 0x03,
0x0A, 0x00, 0x0F, 0x00, 0x0F, 0xF0, 0x0F, 0xF0, 0x0F, 0xFF, 0x0F, 0xFF, 0x0F, 0xF0, 0x0F, 0xF0, 0x0F, 0x00, 0x0F, 0x00, 0x0F,
0x0A, 0x3C, 0x00, 0x3C, 0x00, 0xFC, 0x03, 0xFC, 0x03, 0xFC, 0x3F, 0xFC, 0x3F, 0xFC, 0x03, 0xFC, 0x03, 0x3C, 0x00, 0x3C, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x33, 0xFF, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x30, 0x03, 0x30, 0x03, 0xFF, 0x3F, 0xFF, 0x3F, 0x30, 0x03, 0x30, 0x03, 0xFF, 0x3F, 0xFF, 0x3F, 0x30, 0x03, 0x30, 0x03,
0x0A, 0x30, 0x0C, 0x30, 0x0C, 0xCC, 0x0C, 0xCC, 0x0C, 0xFF, 0x3F, 0xFF, 0x3F, 0xCC, 0x0C, 0xCC, 0x0C, 0x0C, 0x03, 0x0C, 0x03,
0x0A, 0x0F, 0x0C, 0x0F, 0x0C, 0x0F, 0x03, 0x0F, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x3C, 0x30, 0x3C, 0x0C, 0x3C, 0x0C, 0x3C,
0x0A, 0x3C, 0x0F, 0x3C, 0x0F, 0xC3, 0x30, 0xC3, 0x30, 0x3C, 0x33, 0x3C, 0x33, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x33, 0x00, 0x33,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0x0C, 0x0C, 0x0C, 0x0C, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x03, 0x30, 0x0C, 0x0C, 0x0C, 0x0C, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x30, 0x03, 0x30, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x03, 0x30, 0x03,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCC, 0x00, 0xCC, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x03, 0x00, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x00, 0x30, 0x00, 0x0C, 0x00, 0x0C, 0x00,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0x03, 0x33, 0x03, 0x33, 0xC3, 0x30, 0xC3, 0x30, 0x33, 0x30, 0x33, 0x30, 0xFC, 0x0F, 0xFC, 0x0F,
0x0A, 0x30, 0x30, 0x30, 0x30, 0x0C, 0x30, 0x0C, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30,
0x0A, 0x0C, 0x30, 0x0C, 0x30, 0x03, 0x3C, 0x03, 0x3C, 0x03, 0x33, 0x03, 0x33, 0xC3, 0x30, 0xC3, 0x30, 0x3C, 0x30, 0x3C, 0x30,
0x0A, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x30, 0x03, 0x30, 0x33, 0x30, 0x33, 0x30, 0xCF, 0x30, 0xCF, 0x30, 0x03, 0x0F, 0x03, 0x0F,
0x0A, 0xC0, 0x03, 0xC0, 0x03, 0x30, 0x03, 0x30, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x03, 0x00, 0x03,
0x0A, 0x3F, 0x0C, 0x3F, 0x0C, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0xC3, 0x0F, 0xC3, 0x0F,
0x0A, 0xF0, 0x0F, 0xF0, 0x0F, 0xCC, 0x30, 0xCC, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x00, 0x0F, 0x00, 0x0F,
0x0A, 0x03, 0x00, 0x03, 0x00, 0x03, 0x3F, 0x03, 0x3F, 0xC3, 0x00, 0xC3, 0x00, 0x33, 0x00, 0x33, 0x00, 0x0F, 0x00, 0x0F, 0x00,
0x0A, 0x3C, 0x0F, 0x3C, 0x0F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x3C, 0x0F, 0x3C, 0x0F,
0x0A, 0x3C, 0x00, 0x3C, 0x00, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x0C, 0xC3, 0x0C, 0xFC, 0x03, 0xFC, 0x03,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xCC, 0xF0, 0xCC, 0xF0, 0x3C, 0xF0, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x03, 0x30, 0x03, 0x0C, 0x0C, 0x0C, 0x0C, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x03, 0x30, 0x0C, 0x0C, 0x0C, 0x0C, 0x30, 0x03, 0x30, 0x03, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0x0C, 0x00, 0x0C, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x33, 0x03, 0x33, 0xC3, 0x00, 0xC3, 0x00, 0x3C, 0x00, 0x3C, 0x00,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0x03, 0x30, 0x03, 0x30, 0xF3, 0x33, 0xF3, 0x33, 0x33, 0x33, 0x33, 0x33, 0xFC, 0x33, 0xFC, 0x33,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x0C, 0x03, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x3C, 0x0F, 0x3C, 0x0F,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x0C, 0x0C, 0x0C, 0x0C,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x0C, 0x0C, 0x0C, 0x0C, 0xF0, 0x03, 0xF0, 0x03,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x03, 0x30, 0x03, 0x30,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0x03, 0x00, 0x03, 0x00,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0x03, 0x30, 0x03, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xCC, 0x3F, 0xCC, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x30, 0x00, 0x30, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x0F, 0xFF, 0x0F, 0x03, 0x00, 0x03, 0x00,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x03, 0x30, 0x03, 0x0C, 0x0C, 0x0C, 0x0C, 0x03, 0x30, 0x03, 0x30,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x3C, 0x00, 0x3C,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x0C, 0x00, 0x0C, 0x00, 0xF0, 0x00, 0xF0, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x30, 0x00, 0x30, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x00, 0x03, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0xFC, 0x0F, 0xFC, 0x0F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0x3C, 0x00, 0x3C, 0x00,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x33, 0x03, 0x33, 0x03, 0x0C, 0x03, 0x0C, 0xFC, 0x33, 0xFC, 0x33,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x03, 0xC3, 0x03, 0xC3, 0x0C, 0xC3, 0x0C, 0x3C, 0x30, 0x3C, 0x30,
0x0A, 0x3C, 0x30, 0x3C, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x03, 0x0F, 0x03, 0x0F,
0x0A, 0x0F, 0x00, 0x0F, 0x00, 0x03, 0x00, 0x03, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x00, 0x03, 0x00, 0x0F, 0x00, 0x0F, 0x00,
0x0A, 0xFF, 0x0F, 0xFF, 0x0F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0xFF, 0x0F, 0xFF, 0x0F,
0x0A, 0xFF, 0x03, 0xFF, 0x03, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x30, 0x00, 0x30, 0x00, 0x0C, 0x00, 0x0C, 0xFF, 0x03, 0xFF, 0x03,
0x0A, 0xFF, 0x0F, 0xFF, 0x0F, 0x00, 0x30, 0x00, 0x30, 0xF0, 0x0F, 0xF0, 0x0F, 0x00, 0x30, 0x00, 0x30, 0xFF, 0x0F, 0xFF, 0x0F,
0x0A, 0x0F, 0x3C, 0x0F, 0x3C, 0x30, 0x03, 0x30, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x03, 0x30, 0x03, 0x0F, 0x3C, 0x0F, 0x3C,
0x0A, 0x3F, 0x00, 0x3F, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x3F, 0x00, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0x3F, 0x00, 0x3F, 0x00,
0x0A, 0x03, 0x3C, 0x03, 0x3C, 0x03, 0x33, 0x03, 0x33, 0xC3, 0x30, 0xC3, 0x30, 0x33, 0x30, 0x33, 0x30, 0x0F, 0x30, 0x0F, 0x30,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x0C, 0x00, 0x0C, 0x00, 0x30, 0x00, 0x30, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x0C, 0x00, 0x0C,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x30, 0x00, 0x30, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x03, 0x00, 0x03, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x30, 0x00, 0x30, 0x00,
0x0A, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x0C, 0x00, 0x0C, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0xC0, 0x3F, 0xC0, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x30, 0xC0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xC0, 0x0F, 0xC0, 0x0F,
0x0A, 0xC0, 0x0F, 0xC0, 0x0F, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xC0, 0x30, 0xC0, 0x30,
0x0A, 0xC0, 0x0F, 0xC0, 0x0F, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xC0, 0x0F, 0xC0, 0x0F, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0xC0, 0x03, 0xC0, 0x03,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0xFC, 0x3F, 0xFC, 0x3F, 0xC3, 0x00, 0xC3, 0x00, 0x03, 0x00, 0x03, 0x00, 0x0C, 0x00, 0x0C, 0x00,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0xC0, 0x33, 0xC0, 0x33, 0xF0, 0x0F, 0xF0, 0x0F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0xC0, 0x3F, 0xC0, 0x3F,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x30, 0x30, 0xF3, 0x3F, 0xF3, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x30, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0xF3, 0x0F, 0xF3, 0x0F, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0xC0, 0x0C, 0xC0, 0x0C, 0x30, 0x30, 0x30, 0x30,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x30, 0x00, 0x30, 0x00, 0xC0, 0x3F, 0xC0, 0x3F, 0x30, 0x00, 0x30, 0x00, 0xC0, 0x3F, 0xC0, 0x3F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0xC0, 0x3F, 0xC0, 0x3F,
0x0A, 0xC0, 0x0F, 0xC0, 0x0F, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xC0, 0x0F, 0xC0, 0x0F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0xF0, 0x00, 0xF0, 0x00, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0xC0, 0x30, 0xC0, 0x30, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x0C, 0x30, 0x0C,
0x0A, 0x30, 0x00, 0x30, 0x00, 0xFF, 0x0F, 0xFF, 0x0F, 0x30, 0x30, 0x30, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x0C, 0x00, 0x0C,
0x0A, 0xF0, 0x0F, 0xF0, 0x0F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x0C, 0x00, 0x0C, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xF0, 0x03, 0xF0, 0x03, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x30, 0x00, 0x30, 0x00, 0x0C, 0x00, 0x0C, 0xF0, 0x03, 0xF0, 0x03,
0x0A, 0xF0, 0x0F, 0xF0, 0x0F, 0x00, 0x30, 0x00, 0x30, 0xC0, 0x0F, 0xC0, 0x0F, 0x00, 0x30, 0x00, 0x30, 0xF0, 0x0F, 0xF0, 0x0F,
0x0A, 0x30, 0x30, 0x30, 0x30, 0xC0, 0x0C, 0xC0, 0x0C, 0x00, 0x03, 0x00, 0x03, 0xC0, 0x0C, 0xC0, 0x0C, 0x30, 0x30, 0x30, 0x30,
0x0A, 0xF0, 0x00, 0xF0, 0x00, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0xF0, 0x0F, 0xF0, 0x0F,
0x0A, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x30, 0x3C, 0x30, 0x33, 0x30, 0x33, 0xF0, 0x30, 0xF0, 0x30, 0x30, 0x30, 0x30, 0x30,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0x3C, 0x0F, 0x3C, 0x0F, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x03, 0x30, 0x3C, 0x0F, 0x3C, 0x0F, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x0C, 0x00, 0x0C, 0x00, 0x03, 0x00, 0x03, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x30, 0x00, 0x30, 0x00, 0x0C, 0x00, 0x0C, 0x00,
0x0A, 0x00, 0x3F, 0x00, 0x3F, 0xC0, 0x30, 0xC0, 0x30, 0x30, 0x30, 0x30, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0x00, 0x3F, 0x00, 0x3F,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0xFC, 0x00, 0x03, 0x03, 0x03, 0x03, 0xFC, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x03, 0x0C, 0x03, 0xFF, 0x03, 0xFF, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x03, 0x0C, 0x03, 0xC3, 0x03, 0xC3, 0x03, 0x3C, 0x03, 0x3C, 0x03, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x33, 0x03, 0x33, 0x03, 0xCF, 0x00, 0xCF, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0xFF, 0x03, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x03, 0x3F, 0x03, 0x33, 0x03, 0x33, 0x03, 0xC3, 0x00, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0xFC, 0x00, 0x33, 0x03, 0x33, 0x03, 0xC3, 0x00, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0xF3, 0x03, 0xF3, 0x03, 0x0F, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xCC, 0x00, 0xCC, 0x00, 0x33, 0x03, 0x33, 0x03, 0xCC, 0x00, 0xCC, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x03, 0x0C, 0x03, 0x33, 0x03, 0x33, 0x03, 0xFC, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0xFC, 0x0F, 0xFC, 0x0F,
0x0A, 0xC0, 0x33, 0xC0, 0x33, 0x30, 0x3C, 0x30, 0x3C, 0x30, 0x00, 0x30, 0x00, 0x30, 0x3C, 0x30, 0x3C, 0xC0, 0x33, 0xC0, 0x33,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xFC, 0x0F, 0xFC, 0x0F, 0xF0, 0x03, 0xF0, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0xFC, 0x0F, 0xFC, 0x0F, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xFC, 0x0F, 0xFC, 0x0F, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30,
0x0A, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30,
0x0A, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30,
0x0A, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0xC0, 0x3F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x3F, 0xFC, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x3F, 0xFC, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xF0, 0x03, 0xF0, 0x03, 0x3F, 0x3F, 0x3F, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30,
0x0A, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30,
0x0A, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xF0, 0x03, 0xF0, 0x03, 0x3F, 0x3F, 0x3F, 0x3F, 0x03, 0x30, 0x03, 0x30, 0xF3, 0x33, 0xF3, 0x33, 0xF3, 0x33, 0xF3, 0x33,
0x0A, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0xF3, 0x33, 0xF3, 0x33, 0xF3, 0x33, 0xF3, 0x33,
0x0A, 0xF3, 0x33, 0xF3, 0x33, 0xF3, 0x33, 0xF3, 0x33, 0x03, 0x30, 0x03, 0x30, 0xF3, 0x33, 0xF3, 0x33, 0xF3, 0x33, 0xF3, 0x33,
0x0A, 0xF3, 0x33, 0xF3, 0x33, 0xF3, 0x33, 0xF3, 0x33, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0xF0, 0x03, 0xF0, 0x03, 0x30, 0x03, 0x30, 0x03, 0xF0, 0x03, 0xF0, 0x03, 0x0C, 0x0C, 0x0C, 0x0C,
0x0A, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x3F, 0x3F, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x3C, 0x30, 0x3C, 0x30, 0xF3, 0x33, 0xF3, 0x33, 0x33, 0x33, 0x33, 0x33, 0xF3, 0x33, 0xF3, 0x33, 0x03, 0x0F, 0x03, 0x0F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x33, 0x33, 0x33, 0x33, 0x30, 0x33, 0x30, 0x33, 0x33, 0x33, 0x33, 0x33, 0x30, 0x30, 0x30, 0x30,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xCC, 0x0C, 0xCC, 0x0C, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x30, 0x03, 0x30, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x03, 0x30, 0x03, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x03, 0x30, 0x03, 0x0C, 0x0C, 0x0C, 0x0C, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x03, 0x30, 0x03,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x3F, 0x03, 0x3F, 0x03, 0x0F, 0x03, 0x0F, 0xFF, 0x03, 0xFF, 0x03,
0x0A, 0x0F, 0x00, 0x0F, 0x00, 0x33, 0x00, 0x33, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x33, 0x00, 0x33, 0x00, 0x0F, 0x00, 0x0F, 0x00,
0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x30, 0x03, 0x30, 0x03, 0xFF, 0x3F, 0xFF, 0x3F, 0x33, 0x33, 0x33, 0x33, 0x0C, 0x0C, 0x0C, 0x0C,
0x0A, 0x0C, 0x00, 0x0C, 0x00, 0x33, 0x33, 0x33, 0x33, 0xF3, 0x3F, 0xF3, 0x3F, 0x33, 0x00, 0x33, 0x00, 0x0C, 0x00, 0x0C, 0x00,
0x0A, 0x3C, 0x00, 0x3C, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xFF, 0x33, 0xFF, 0x33, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
0x0A, 0xF0, 0x03, 0xF0, 0x03, 0x30, 0x03, 0x30, 0x03, 0xF0, 0x03, 0xF0, 0x03, 0x0C, 0x0C, 0x0C, 0x0C, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0x00, 0x0C, 0x00, 0x0C, 0xFC, 0x0F, 0xFC, 0x0F, 0x03, 0x3C, 0x03, 0x3C, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x0C, 0x00, 0x0C,
0x0A, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x33, 0x00, 0x33, 0xFF, 0x0F, 0xFF, 0x0F, 0x0C, 0x00, 0x0C, 0x00, 0xF0, 0x00, 0xF0, 0x00,
0x0A, 0x00, 0xC0, 0x00, 0xC0, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x0C, 0x00, 0x0C, 0xF0, 0x0F, 0xF0, 0x0F, 0x00, 0x30, 0x00, 0x30,
0x0A, 0x30, 0x30, 0x30, 0x30, 0xF0, 0x0F, 0xF0, 0x0F, 0x30, 0x00, 0x30, 0x00, 0xF0, 0x3F, 0xF0, 0x3F, 0x30, 0x30, 0x30, 0x30,
0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0A, 0xC0, 0x0F, 0xC0, 0x0F, 0x33, 0x33, 0x33, 0x33, 0x30, 0x33, 0x30, 0x33, 0x33, 0x33, 0x33, 0x33, 0xC0, 0x03, 0xC0, 0x03,
0x0A, 0xFC, 0x3F, 0xFC, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x00, 0x03, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x00, 0x03, 0x00,
0x0A, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x00, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x00, 0x30, 0x00, 0x0C, 0x00, 0x0C, 0x00,
0x0A, 0x30, 0x03, 0x30, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x30, 0x03, 0x30, 0x03, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0xFC, 0x00, 0xFC, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0xCC, 0x00, 0xCC, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x0C, 0x00, 0x0C,
0x0A, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x03, 0x00, 0x03, 0xCC, 0x00, 0xCC, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0xFC, 0x00, 0xFC, 0x00,
0x0A, 0xC0, 0x0F, 0xC0, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0xC0, 0x0C, 0xC0, 0x0C, 0x30, 0x00, 0x30, 0x00, 0x0C, 0x00, 0x0C, 0x00,
0x0A, 0x0C, 0x00, 0x0C, 0x00, 0x30, 0x00, 0x30, 0x00, 0xC0, 0x0C, 0xC0, 0x0C, 0x00, 0x0F, 0x00, 0x0F, 0xC0, 0x0F, 0xC0, 0x0F,
0x0A, 0xFC, 0x3F, 0xFC, 0x3F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xFC, 0x3F, 0xFC, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x03, 0x0F, 0x03, 0x0F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x3C, 0x0F, 0x3C, 0x0F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x0F, 0x00, 0x0F, 0x00,
0x0A, 0x00, 0xF0, 0x00, 0xF0, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0xF0, 0x00, 0xF0,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x03, 0x30, 0x03, 0x30,
0x0A, 0x3F, 0x3F, 0x3F, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0x3F, 0x3F, 0x3F, 0x3F,
0x0A, 0x03, 0x30, 0x03, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x3C, 0x0F, 0x3C, 0x0F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x03, 0x00, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x00, 0x30, 0x00, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x03, 0x0C, 0x03, 0x0C, 0x0C, 0x03, 0x0C, 0x03, 0xC3, 0x00, 0xC3, 0x00, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x03, 0x30, 0x03, 0x0C, 0x0C, 0x0C, 0x0C, 0x03, 0x30, 0x03, 0x30,
0x0A, 0x00, 0x30, 0x00, 0x30, 0xFC, 0x0F, 0xFC, 0x0F, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x0C, 0x00, 0x0C, 0x00, 0xF0, 0x00, 0xF0, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0xFC, 0x0F, 0xFC, 0x0F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0x3C, 0x00, 0x3C, 0x00,
0x0A, 0xFC, 0x0F, 0xFC, 0x0F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x0C, 0x0C, 0x0C, 0x0C,
0x0A, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00,
0x0A, 0x3F, 0x00, 0x3F, 0x00, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0xFF, 0x0F, 0xFF, 0x0F,
0x0A, 0xFC, 0x00, 0xFC, 0x00, 0x03, 0x03, 0x03, 0x03, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x03, 0x03, 0x03, 0xFC, 0x00, 0xFC, 0x00,
0x0A, 0x0F, 0x3C, 0x0F, 0x3C, 0x30, 0x03, 0x30, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0x30, 0x03, 0x30, 0x03, 0x0F, 0x3C, 0x0F, 0x3C,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0xF0, 0x00, 0xF0,
0x0A, 0x3F, 0x00, 0x3F, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xFF, 0xFF, 0xFF, 0xFF,
0x0A, 0x03, 0x00, 0x03, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0x00, 0x0F, 0x00, 0x0F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0x00, 0x0F, 0x00, 0x0F, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0xC0, 0x30, 0x00, 0x0F, 0x00, 0x0F,
0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x03, 0x30, 0x03, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xFC, 0x0F, 0xFC, 0x0F,
0x0A, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x03, 0x30, 0x03, 0x30, 0xFC, 0x0F, 0xFC, 0x0F,
0x0A, 0x3C, 0x30, 0x3C, 0x30, 0xC3, 0x0C, 0xC3, 0x0C, 0xC3, 0x03, 0xC3, 0x03, 0xC3, 0x00, 0xC3, 0x00, 0xFF, 0x3F, 0xFF, 0x3F,
0x0A, 0x00, 0x0C, 0x00, 0x0C, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0xC0, 0x3F, 0xC0, 0x3F,
0x0A, 0xF0, 0x0F, 0xF0, 0x0F, 0xCC, 0x30, 0xCC, 0x30, 0xCC, 0x30, 0xCC, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x03, 0x0F, 0x03, 0x0F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0xC0, 0x0C, 0xC0, 0x0C,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0xF0, 0x00, 0xF0, 0x00,
0x0A, 0x00, 0xF0, 0x00, 0xF0, 0xC0, 0x3F, 0xC0, 0x3F, 0x30, 0x30, 0x30, 0x30, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0xF0, 0x00, 0xF0,
0x0A, 0xC0, 0x0F, 0xC0, 0x0F, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0xC0, 0x03, 0xC0, 0x03,
0x0A, 0xF0, 0x3C, 0xF0, 0x3C, 0x00, 0x03, 0x00, 0x03, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x03, 0x00, 0x03, 0xF0, 0x3C, 0xF0, 0x3C,
0x0A, 0x30, 0x30, 0x30, 0x30, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0xC0, 0x0C, 0xC0, 0x0C,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x03, 0x00, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x3C, 0x0C, 0x3C, 0x0C, 0x00, 0x03, 0x00, 0x03, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0xC0, 0x0C, 0xC0, 0x0C, 0x30, 0x30, 0x30, 0x30,
0x0A, 0x00, 0x30, 0x00, 0x30, 0xC0, 0x0F, 0xC0, 0x0F, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x00, 0x03, 0xC0, 0x00, 0xC0, 0x00, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xC0, 0x0F, 0xC0, 0x0F, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xC0, 0x0F, 0xC0, 0x0F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0xC0, 0x00, 0xC0, 0x00,
0x0A, 0xC0, 0x0F, 0xC0, 0x0F, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xC0, 0x30, 0xC0, 0x30,
0x0A, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0xF0, 0x3F, 0xF0, 0x3F, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
0x0A, 0xF0, 0x00, 0xF0, 0x00, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0xF0, 0x0F, 0xF0, 0x0F,
0x0A, 0xC0, 0x03, 0xC0, 0x03, 0x30, 0x0C, 0x30, 0x0C, 0xF0, 0xFF, 0xF0, 0xFF, 0x30, 0x0C, 0x30, 0x0C, 0xC0, 0x03, 0xC0, 0x03,
0x0A, 0x30, 0x30, 0x30, 0x30, 0xC0, 0x0C, 0xC0, 0x0C, 0x00, 0x03, 0x00, 0x03, 0xC0, 0x0C, 0xC0, 0x0C, 0x30, 0x30, 0x30, 0x30,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0xF0, 0x00, 0xF0,
0x0A, 0xF0, 0x00, 0xF0, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x30, 0x00, 0x30, 0xF0, 0xFF, 0xF0, 0xFF,
0x0A, 0x30, 0x00, 0x30, 0x00, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x0C, 0x00, 0x0C,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x0C, 0x00, 0x0C, 0xF0, 0x3F, 0xF0, 0x3F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x0C, 0x00, 0x0C,
0x0A, 0xC0, 0x0C, 0xC0, 0x0C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0xC0, 0x0F, 0xC0, 0x0F,
0x0A, 0xF0, 0x3F, 0xF0, 0x3F, 0x00, 0x03, 0x00, 0x03, 0xC0, 0x0F, 0xC0, 0x0F, 0x30, 0x30, 0x30, 0x30, 0xC0, 0x0F, 0xC0, 0x0F,
0x0A, 0xC0, 0x30, 0xC0, 0x30, 0x30, 0x0F, 0x30, 0x0F, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0xF0, 0x3F, 0xF0, 0x3F
};
#endif // YOFONT10X14_H
