#include "../../core/options.h"
#if DSP_MODEL!=DSP_DUMMY && DSP_MODEL==DSP_ILI9488
#include "../dspcore.h"
#include "widgets.h"
#include "weatherwidget.h"
#include <string.h>

extern DspCore dsp;

void WeatherIconWidget::init(WidgetConfig wconf, uint16_t fgcolor, uint16_t bgcolor) {
  Widget::init(wconf, fgcolor, bgcolor);
  _img = nullptr;
  _iw = 64;
  _ih = 64;
  _active = true;
}

void WeatherIconWidget::setIcon(const char* code) {
  if(!code || strlen(code) < 2) {
    _img = nullptr;
    return;
  }
  
  // Mapowanie kodów pogody na ikony (OpenWeatherMap format)
  if(strncmp(code, "01d", 3) == 0) _img = img_01d;
  else if(strncmp(code, "01n", 3) == 0) _img = img_01n;
  else if(strncmp(code, "02d", 3) == 0) _img = img_02d;
  else if(strncmp(code, "02n", 3) == 0) _img = img_02n;
  else if(strncmp(code, "03d", 3) == 0) _img = img_03;
  else if(strncmp(code, "03n", 3) == 0) _img = img_03;
  else if(strncmp(code, "04d", 3) == 0) _img = img_04d;
  else if(strncmp(code, "04n", 3) == 0) _img = img_04n;
  else if(strncmp(code, "09d", 3) == 0) _img = img_09d;
  else if(strncmp(code, "09n", 3) == 0) _img = img_09n;
  else if(strncmp(code, "10d", 3) == 0) _img = img_10d;
  else if(strncmp(code, "10n", 3) == 0) _img = img_10n;
  else if(strncmp(code, "11", 2) == 0) _img = img_11;
  else if(strncmp(code, "13d", 3) == 0) _img = img_13d;
  else if(strncmp(code, "13n", 3) == 0) _img = img_13n;
  else if(strncmp(code, "50d", 3) == 0) _img = img_50d;
  else if(strncmp(code, "50n", 3) == 0) _img = img_50n;
  else {
    _img = nullptr;
    return;
  }
  
  if(!_locked && _active) {
    _draw();
  }
}

void WeatherIconWidget::_draw() {
  if(!_img || _locked) return;
  dsp.drawRGBBitmap(_config.left + 60, _config.top, _img, _iw, _ih);
}

void WeatherIconWidget::_clear() {
  if(_locked) return;
  dsp.fillRect(_config.left, _config.top, _iw, _ih, _bgcolor);
}

void WeatherIconWidget::_reset() {
  // Nic do robienia
}

#endif
